<?php

use App\Http\Controllers\Temp\EmployeeController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\TraineeCertificateController;
use App\Http\Controllers\TrainerCertificateController;
use App\Http\Controllers\UserEventCertificate;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('login', function () {
    return redirect(route('filament.user.auth.login'));
})->name('login');



#############################
Route::get('/id', [\App\Http\Controllers\IdCardController::class, 'show'])
    ->middleware(['auth:general_user'])
    ->name('user.id_card');

Route::get('/id/pdf', [\App\Http\Controllers\IdCardController::class, 'pdf'])
    ->middleware(['auth:general_user'])
    ->name('user.id_card.pdf');

Route::get('/card/{user}', [\App\Http\Controllers\IdCardController::class, 'showGuestId'])
    ->name('guest.id');


#####################

Route::get('/certificate/trainee/{course}', [TraineeCertificateController::class, 'show'])
    ->middleware(['auth'])
    ->name('trainee.certificate');

Route::get('/certificate/trainer/{course}', [TrainerCertificateController::class, 'show'])
    ->middleware(['auth'])
    ->name('trainer.certificate');

Route::get('/certificate/trainee/{course}/{user}/admin', [TraineeCertificateController::class, 'adminShow'])
    ->middleware(['auth:admin'])
    ->name('admin.trainee.certificate');

Route::get('/certificate/trainer/{course}/{user}/admin', [TrainerCertificateController::class, 'adminShow'])
    ->middleware(['auth:admin'])
    ->name('admin.trainer.certificate');

Route::get('/event/user/{event}', [UserEventCertificate::class, 'show'])
    ->middleware(['auth'])
    ->name('user.event.certificate');

Route::get('/event/user/{event}/{user}/admin', [UserEventCertificate::class, 'adminShow'])
    ->middleware(['auth:admin'])
    ->name('admin.event.certificate');

Route::get('/event-certs/search', [UserEventCertificate::class, 'SearchForGuest'])
    ->name('guest.event.certificate.search');

Route::get('/event-certs/{user:national_id}', [UserEventCertificate::class, 'guestCerts'])
    ->name('guest.event.certificate.index');

Route::get('/event-certs/{user:national_id}/{event}', [UserEventCertificate::class, 'guestCert'])
    ->name('guest.event.certificate.show');


Route::get('/emp/import', [EmployeeController::class, 'import']);

Route::get('/emp/login', [EmployeeController::class, 'loginForm'])
    ->name('temp.emp.login');

Route::get('/emp/{employee}', [EmployeeController::class, 'show'])
    ->name('temp.employee.show');


// update the employee data
Route::post('/emp/{employee}', [EmployeeController::class, 'update'])
    ->name('temp.employee.update');

Route::get('/upload-form', [FileController::class, 'showForm']);
Route::post('/upload', [FileController::class, 'upload']);

Route::post('/upload-file', [FileController::class, 'uploadFile']);
