<!DOCTYPE html>
<html lang="ar" dir="rtl">

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>
        تعديل بيانات المشرفين/ ـات
    </title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body {
            text-align: right;
        }

        /* Styles for wrapping the search box */

        .main {
            width: 90%;
            margin: 50px auto;
        }

        /* Bootstrap 4 text input with search icon */

        .has-search .form-control {
            padding-left: 2.375rem;
        }

        .has-search .form-control-feedback {
            position: absolute;
            z-index: 2;
            display: block;
            width: 2.375rem;
            height: 2.375rem;
            line-height: 2.375rem;
            text-align: center;
            pointer-events: none;
            color: #aaa;
        }

        footer {
            position: fixed;
            left: 0;
            bottom: 0;
            width: 100%;
            background-color: #f5f5f5;
            text-align: center;
        }

        .container {
            margin-top: 20px;
            margin-bottom: 70px;
        }
    </style>
</head>

    <!-- Add the following script for the desired functionality -->
        <script>
        document.addEventListener("DOMContentLoaded", function () {
            document.getElementById("updateForm").addEventListener("submit", function (event) {
                // Check if all required fields are completed
                var isFormValid = validateForm();
                
                if (!isFormValid) {
                    // Prevent the form submission if not all fields are completed
                    event.preventDefault();
                } else {
                    // Display the success message box
                    alert("شكـراً تم التحديث");
                }
            });

            function validateForm() {
                // Add validation logic for each required field
                var email = document.getElementById("email").value;
                var mobile = document.getElementById("phone").value;
                var supervisory_work_assignment_date = document.getElementById("supervisory_work_assignment_date").value;
                var current_department_assignment_date = document.getElementById("current_department_assignment_date").value;

                if (email === "" || mobile === ""){
                    alert("الرجاء ملء جميع الحقول المطلوبة.");
                    return false;
                }

                // Add more validation logic for other fields if needed

                return true;
            }
        });
    </script>
</head>

<body>
<div class="container">
    <div class="text-center">
        <img src="https://upload.wikimedia.org/wikipedia/ar/thumb/2/20/MOELogo.svg/1200px-MOELogo.svg.png"
             alt="logo" width="200">
    </div>
    <hr>
    @if(isset($error) && $error)
        <div class="alert alert-danger">
            {{ $error }}
        </div>
    @endif

    @if(isset($success))
        <div class="alert alert-success">
            {{ $success }}
        </div>
    @endif

        <form method="post" action="{{ route("temp.employee.update" , $emp) }}" id="updateForm">
       @csrf
        <div class="form-group row">
            <label for="name" class="col-4 col-form-label">
                الاسم الرباعي باللغة العربية
                <p class="text-muted">
                    وفقاً للهوية الوطنية
                </p>
            </label>                <div class="col-8">
                <input id="name" name="name" type="text" class="form-control" value="{{ old('supervisor_name' , $emp->supervisor_name) }}" disabled>
            </div>
        </div>

        <div class="form-group row">
            <label for="education_sector" class="col-4 col-form-label">
                القطاع التعليمي
            </label>
            <div class="col-8">
                <input id="education_sector" type="text" class="form-control" value="{{ old('education_sector' , $emp->education_sector) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="education_office" class="col-4 col-form-label">مكتب التعليم</label>
            <div class="col-8">
                <input id="education_office" type="text" class="form-control" value="{{ old('education_office' , $emp->education_office) }}" disabled="">
            </div>
        </div>


        <div class="form-group row">
            <label for="civil_registry" class="col-4 col-form-label">السجل المدني</label>
            <div class="col-8">
                <input id="civil_registry" type="text" class="form-control" value="{{ old('civil_registry' , $emp->civil_registry) }}" disabled="">
            </div>
        </div>


        <div class="form-group row">
            <label class="col-4">الفئة</label>
            <div class="col-8">
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="gender" id="fea_0" type="radio" class="custom-control-input" value="boys" disabled @if($emp->gender == "بنين") checked  @endif >
                    <label for="fea_0" class="custom-control-label">بنين</label>
                </div>
                <div class="custom-control custom-radio custom-control-inline">
                    <input name="gender" id="fea_1" type="radio" class="custom-control-input" value="girls" disabled @if($emp->gender == "بنات") checked  @endif >
                    <label for="fea_1" class="custom-control-label">بنات</label>
                </div>
            </div>
        </div>


        <div class="form-group row">
            <label for="specialization" class="col-4 col-form-label">
                التخصص
            </label>
            <div class="col-8">
                <input id="specialization" type="text" class="form-control" value="{{ old('specialization' , $emp->specialization) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="qualification" class="col-4 col-form-label">
                المؤهل
            </label>
            <div class="col-8">
                <input id="qualification" type="text" class="form-control" value="{{ old('qualification' , $emp->qualification) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="university_college_institute" class="col-4 col-form-label">الجامعة الكلية المعهد</label>
            <div class="col-8">
                <input id="university_college_institute" type="text" class="form-control" value="{{ old('university_college_institute' , $emp->university_college_institute) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="educational_directorate_day" class="col-4 col-form-label">تاريخ المباشرة التعليمية</label>
            <div class="col-8">
                <input id="educational_directorate_day" type="text" class="form-control" value="{{ old('educational_directorate_date' , $emp->educational_directorate_day. "/" . $emp->educational_directorate_month . "/" . $emp->educational_directorate_year) }}" disabled="">
            </div>
        </div>


        <div class="form-group row">
            <label for="rank" class="col-4 col-form-label">الرتبة</label>
            <div class="col-8">
                <input id="rank" type="text" class="form-control" value="{{ old('rank' , $emp->rank) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="job_title" class="col-4 col-form-label">المسمى الوظيفي</label>
            <div class="col-8">
                <input id="job_title" type="text" class="form-control" value="{{ old('job_title' , $emp->job_title) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="employee_status" class="col-4 col-form-label">حالة الموظف</label>
            <div class="col-8">
                <input id="employee_status" type="text" class="form-control" value="{{ old('employee_status' , $emp->employee_status) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="performance_year_1443" class="col-4 col-form-label">الأداء الوظيفي للعام1443</label>
            <div class="col-8">
                <input id="performance_year_1443" type="text" class="form-control" value="{{ old('performance_year_1443' , $emp->performance_year_1443) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="performance_year_1444" class="col-4 col-form-label">الأداء الوظيفي للعام 1444</label>
            <div class="col-8">
                <input id="performance_year_1444" type="text" class="form-control" value="{{ old('performance_year_1444' , $emp->performance_year_1444) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="current_job" class="col-4 col-form-label">العمل الحالي</label>
            <div class="col-8">
                <input id="current_job" type="text" class="form-control" value="{{ old('current_job' , $emp->current_job) }}" disabled="">
            </div>
        </div>

        <div class="form-group row">
            <label for="email" class="col-4 col-form-label">البريد الإلكتروني</label>
            <div class="col-8">
                <input id="email" type="email" class="form-control"  value="{{ old('email' , $emp->email) }}" required name="email">
            </div>
        </div>


        <div class="form-group row">
            <label for="mobile" class="col-4 col-form-label">رقم الجوال</label>
            <div class="col-8">
                <input id="phone" name="mobile" type="text" class="form-control" required="required" value="{{ old('mobile' , $emp->mobile) }}" >
            </div>

            @error('phone')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>


        <div class="form-group row">
            <label for="office" class="col-4 col-form-label">
                نوع المؤهل
            </label>
            <div class="col-8">
                <select id="qualification_type" name="qualification_type" class="custom-select" required="required" value="{{ old('qualification_type' , $emp->qualification_type) }}">
                    <option value="">اختر</option>
                    @foreach($qualification_types as $qualification_type)
                        <option value="{{ $qualification_type }}" @if($emp->qualification_type == $qualification_type) selected @endif >
                            {{ $qualification_type }}
                        </option>
                    @endforeach
                </select>
            </div>

            @error('additional_qualifications')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>


        <div class="form-group row">
            <label for="office" class="col-4 col-form-label">
                مؤهلات إضافية
            </label>
            <div class="col-8">
                <select id="additional_qualifications" name="additional_qualifications" class="custom-select" required="required" value="{{ old('additional_qualifications' , $emp->additional_qualifications) }}">
                    <option value="">اختر</option>
                    @foreach($additional_qualifications as $additional_qualification)
                        <option value="{{ $additional_qualification }}" @if($emp->additional_qualifications == $additional_qualification) selected @endif >
                            {{ $additional_qualification }}
                        </option>
                    @endforeach
                </select>
            </div>

            
            @error('additional_qualifications')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group row">
            <label for="additional_qualification_specialization" class="col-4 col-form-label">
                تخصص المؤهل الإضافي
            </label>
            <div class="col-8">
                <div class="col-8">
                    <input id="additional_qualification_specialization" type="text" class="form-control"  value="{{ old('additional_qualification_specialization' , $emp->additional_qualification_specialization) }}" required name="additional_qualification_specialization">
                </div>
            </div>

            @error('additional_qualification_specialization')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group row">
            <label for="supervisory_work_assignment_date" class="col-4 col-form-label">تاريخ أول تكليف بالعمل الإشرافي (yyyy/mm/dd) </label>
            <div class="col-8">
                <input id="supervisory_work_assignment_date" type="text" class="form-control" value="{{ old('supervisory_work_assignment_date' , $emp->supervisory_work_assignment_date) }}" required name="supervisory_work_assignment_date">
            </div>

            @error('supervisory_work_assignment_date')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>

        <div class="form-group row">
            <label for="current_department_assignment_date" class="col-4 col-form-label"> تاريخ التكليف في القسم الحالي (yyyy/mm/dd) </label>
            <div class="col-8">
                <input id="current_department_assignment_date" type="text" class="form-control" value="{{ old('current_department_assignment_date' , $emp->current_department_assignment_date) }}" required name="current_department_assignment_date">
            </div>

            @error('current_department_assignment_date')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>



            <div class="form-group row">
                <label class="col-4">أتعهد أن البيانات أعلاه صحيحة وأتحمل كامل المسؤولية .</label>
                <div class="col-8">
                    <div class="custom-control custom-checkbox custom-control-inline">
                        <input name="info_correct" id="info_correct_0" type="checkbox" class="custom-control-input"
                            value="ok" @if($emp->info_correct) checked @endif>
                        <label for="info_correct_0" class="custom-control-label">موافق</label>
                    </div>
                </div>
            </div>

<div class="form-group row">
    <label class="col-4">في حال وجود خطأ في بياناتي أتعهد بمراجعة شؤون المعلمين لتعديلها خلال مدة 3 أيام من تاريخه .</label>
    <div class="col-8">
        <div class="custom-control custom-checkbox custom-control-inline">
            <input name="info_correct1" id="info_correct_1" type="checkbox" class="custom-control-input" value="1" @if($emp->info_correct1) checked @endif>
            <label for="info_correct_1" class="custom-control-label">موافق</label>
        </div>
    </div>
</div>

            <div class="form-group row">
                <div class="offset-4 col-8">
                    <button type="submit" class="btn btn-primary">تحديث</button>
                </div>
            </div>
        </form>
    </div>

    <footer class="text-center">
        <p>جميع الحقوق محفوظة لتقنية المعلومات - بيشة</p>
    </footer>

</body>

</html>
