<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title>
        {{ $event->title }}
    </title>
    <link rel="stylesheet" href="{{ asset('certs/css/style.css') }}" />
</head>
<body>
<div id="pdf"></div>
<script src="{{ asset('certs/js/pdf-lib.min.js') }}"></script>
<script src="{{ asset('certs/js/fontkit.umd.min.js') }}"></script>
<script src="{{ asset('certs/js/filesaver.js') }}"></script>
<script src="{{ asset('certs/js/index2.js') . "?t=" . time() }}"></script>
<script>
    const temp = "{{ $temp }}";
    const font = "{{ asset('certs/fonts/IBMPlexSansArabic-Bold.ttf') }}";
    const content = `{{ $content }}`;
    const download = {{ isset($download) && $download ? 'true' : 'false' }};
    const fileName = "{{ $event->title }} - {{ $user->name }}.pdf";
    generatePDF(
        download,
        fileName,
        content,
    );
</script>
</body>
</html>
