const { PDFDocument, rgb, degrees } = PDFLib;


const generatePDF = async (download , fileName , content) => {
    const existingPdfBytes = await fetch(temp).then((res) => res.arrayBuffer());

    // Load a PDFDocument from the existing PDF bytes
    const pdfDoc = await PDFDocument.load(existingPdfBytes);
    pdfDoc.registerFontkit(fontkit);

    //get font
    const fontBytes = await fetch(font).then((res) => res.arrayBuffer());
    // Embed our custom font in the document
    const _font = await pdfDoc.embedFont(fontBytes);
    // Get the first page of the document
    const pages = pdfDoc.getPages();
    const firstPage = pages[0];

    var lines = content.split('\n');

    var lineHeights = 0;

    lines.forEach((line , index) => {
        let textSize = 24;
        let textWidth = _font.widthOfTextAtSize(line, textSize);
        let textHeight = _font.heightAtSize(textSize);

        let colorRGB = rgb(0,0,0);

        if(index === 0) {
            colorRGB = rgb(139/255, 0, 0);
        }else{
             textSize = 30;
             textWidth = _font.widthOfTextAtSize(line, textSize);
             textHeight = _font.heightAtSize(textSize);
        }

        console.log(textWidth , textHeight , lineHeights , index , colorRGB)

        // Draw a string of text diagonally across the first page
        firstPage.drawText(line, {
            x: (firstPage.getWidth() / 2 - textWidth / 2),
            y: ((firstPage.getHeight() / 2 - textHeight / 2) - lineHeights) + 180, // should be 80
            size: textSize,
            font: _font,
            bold: true,
            color: colorRGB,
        });

        lineHeights += textHeight;
    });


    // Serialize the PDFDocument to bytes (a Uint8Array)
    const pdfDataUri = await pdfDoc.saveAsBase64({ dataUri: true });

    const pdfPreview = document.createElement("embed");
    pdfPreview.src = pdfDataUri;
    pdfPreview.type = "application/pdf";
    pdfPreview.width = "100%";
    pdfPreview.height = "100%";
    pdfPreview.style.direction = "rtl";
    pdfPreview.style.textAlign = "right";
    const pdfContainer = document.getElementById("pdf");
    pdfContainer.appendChild(pdfPreview);

    saveAs(pdfDataUri, fileName)

    // if(download) {
    //     saveAs(pdfDataUri, fileName)
    // }
};
