const { PDFDocument, rgb, degrees } = PDFLib;


const generatePDF = async (download , fileName , name, course, startDate, endDate, days, hours) => {
    const existingPdfBytes = await fetch(temp).then((res) => res.arrayBuffer());

    // Load a PDFDocument from the existing PDF bytes
    const pdfDoc = await PDFDocument.load(existingPdfBytes);
    pdfDoc.registerFontkit(fontkit);

    //get font
    const fontBytes = await fetch(font).then((res) => res.arrayBuffer());
    // Embed our custom font in the document
    const SanChezFont = await pdfDoc.embedFont(fontBytes);
    // Get the first page of the document
    const pages = pdfDoc.getPages();
    const firstPage = pages[0];

    // Draw a string of text diagonally across the first page
    firstPage.drawText(name, {
        x: 300,
        y: 325,
        size: 20,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    firstPage.drawText(course, {
        x: 300,
        y: 285,
        size: 20,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    firstPage.drawText(startDate, {
        x: 500,
        y: 242,
        size: 16,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    firstPage.drawText(endDate, {
        x: 350,
        y: 242,
        size: 16,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    firstPage.drawText(days, {
        x: 260,
        y: 242,
        size: 16,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    firstPage.drawText(hours, {
        x: 120,
        y: 242,
        size: 16,
        font: SanChezFont,
        color: rgb(0.2, 0.84, 0.67),
    });

    // Serialize the PDFDocument to bytes (a Uint8Array)
    const pdfDataUri = await pdfDoc.saveAsBase64({ dataUri: true });

    const pdfPreview = document.createElement("embed");
    pdfPreview.src = pdfDataUri;
    pdfPreview.type = "application/pdf";
    pdfPreview.width = "100%";
    pdfPreview.height = "100%";
    pdfPreview.style.direction = "rtl";
    pdfPreview.style.textAlign = "right";
    const pdfContainer = document.getElementById("pdf");
    pdfContainer.appendChild(pdfPreview);

    if(download) {
        saveAs(pdfDataUri, fileName)
    }
};
