<?php

namespace Database\Seeders;

use App\Models\Office;
use App\Models\School;
use Illuminate\Database\Seeder;

class OfficesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $json = [
            [
                'name_ar' => 'وسط بيشة',
                'name_en' => 'Bishah-mid',
            ],
            [
                'name_ar' => 'تثليث',
                'name_en' => 'Tathleeth',
            ],
            [
                'name_ar' => 'الثنية و تبالة',
                'name_en' => 'Althaneya',
            ],
            [
                'name_ar' => 'بلقرن',
                'name_en' => 'Bilqarn',
            ],
        ];

        collect($json)->each(function ($el) {
            $office = Office::create([
                'name' => $el['name_ar'],
            ]);

            if (app()->environment('local')) {
                School::factory(2)->create([
                    'office_id' => $office->id,
                ]);
            }
        });
    }
}
