<?php

namespace Database\Seeders;

use App\Models\CourseType;
use Illuminate\Database\Seeder;

class CourseTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $types = [
            [
                'name_ar' => 'ندوة',
                'name_en' => 'Seminar',
            ],
            [
                'name_ar' => 'لقاء',
                'name_en' => 'Meeting',
            ],
            [
                'name_ar' => 'دورة تدريبية',
                'name_en' => 'Training Course',
            ],
            [
                'name_ar' => 'مشغل تربوي',
                'name_en' => 'Educational Operator',
            ],
            [
                'name_ar' => 'درس تطبيقي',
                'name_en' => 'Practical Lesson',
            ],
            [
                'name_ar' => 'محاضرة',
                'name_en' => 'Lecture',
            ],
        ];

        foreach ($types as $type) {
            CourseType::create([
                'name' => $type['name_ar'],
            ]);
        }
    }
}
