<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_type_id')->nullable()->constrained('course_types')->nullOnDelete();
            $table->foreignId('course_field_id')->nullable()->constrained('course_fields')->nullOnDelete();
            $table->unsignedSmallInteger('hours')->default(0);
            $table->unsignedSmallInteger('max_trainees')->default(0);
            $table->unsignedSmallInteger('max_trainees_per_school')->default(0);
            $table->timestamp('start_at')->nullable();
            $table->timestamp('end_at')->nullable();
            $table->string('title');

            $table->boolean('is_online')->default(false);
            $table->boolean('is_for_boys')->default(true);
            $table->boolean('is_for_girls')->default(false);
            $table->boolean('is_for_edu_job')->default(true);
            $table->boolean('is_for_manager_job')->default(false);

            $table->boolean('is_for_all_offices')->default(true);

            $table->string('meeting_link')->nullable();
            $table->string('meeting_password')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
