<?php

namespace App\Providers\Filament;

use App\Filament\Employee\Pages\Login;
use App\Filament\Employee\Widgets\ChangeDefaultPasswordWidget;
use App\Filament\GeneralUser\Pages\EditProfile;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Navigation\NavigationItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class GeneralUserPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('generalUser')
            ->path('general')
            ->brandName('تعليم بيشة')
            ->colors([
                'primary' => Color::Green,
            ])
            // ->spa()
            ->maxContentWidth('full')
            ->sidebarCollapsibleOnDesktop()
            ->login(Login::class)
            ->profile(EditProfile::class)
            ->passwordReset()
            ->authGuard('general_user')
            ->discoverResources(in: app_path('Filament/GeneralUser/Resources'), for: 'App\\Filament\\GeneralUser\\Resources')
            ->discoverPages(in: app_path('Filament/GeneralUser/Pages'), for: 'App\\Filament\\GeneralUser\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/GeneralUser/Widgets'), for: 'App\\Filament\\GeneralUser\\Widgets')
            ->widgets([
                Widgets\AccountWidget::class,
                ChangeDefaultPasswordWidget::class,
            ])
            ->navigationItems([
                NavigationItem::make("courses")
                    ->label("الدورات")
                    ->url(fn (): string => route('filament.user.pages.dashboard'))
                    ->icon('heroicon-o-beaker')
                    ->sort(3),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ]);
    }
}
