<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class CourseTrainee extends Model
{
    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public function attendances(): HasMany
    {
        return $this->hasMany(Attendance::class);
    }

    public function trainee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'trainee_id')->where('is_trainee', true)->withTrashed();
    }
}
