<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class CertificateEvent extends Model
{
    use softDeletes;

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'certificate_event_users')->withPivot('id');
    }

    public function scopeOfCurrentUser($query)
    {
        return $query->whereHas('users', function ($q) {
            $q->where('user_id', auth()->id());
        });
    }

    public function replaceVarsWithUser(User $user): self
    {
        $replaces = [
            '__user_name__' => $user->name,
            '__national_id__' => $user->national_id,
        ];

        foreach ($replaces as $key => $value) {
            $this->content = str_replace($key, $value, $this->content);
        }

        // replace new lines

        return $this;
    }
}
