<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Attendance extends Model
{
    protected $casts = [
        'attended_at' => 'datetime',
        'is_attended' => 'boolean',
    ];

    public $timestamps = false;

    public function courseTrainee(): BelongsTo
    {
        return $this->belongsTo(CourseTrainee::class, 'course_trainee_id');
    }

    public function trainee()
    {
        return $this->hasOneThrough(
            User::class,
            CourseTrainee::class,
            'id', // Foreign key on the CourseTrainee table...
            'id', // Foreign key on the User table...
            'course_trainee_id', // Local key on the Attendance table...
            'trainee_id' // Local key on the CourseTrainee table...)
        );
    }

    public function course()
    {
        return $this->hasOneThrough(
            Course::class,
            CourseTrainee::class,
            'id', // Foreign key on the CourseTrainee table...
            'id', // Foreign key on the Course table...
            'course_trainee_id', // Local key on the Attendance table...
            'course_id' // Local key on the CourseTrainee table...)
        );
    }
}
