<?php

namespace App\Imports;

use App\Models\TempEmployee;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class TempEmpImport implements ToModel, WithHeadingRow
{
    public function startRow(): int
    {
        return 2;
    }

    public function model(array $row)
    {
        return new TempEmployee([
            'gender' => $row['algns'],
            'education_sector' => $row['alktaaa_altaalymy'],
            'education_office' => $row['mktb_altaalym'],
            'civil_registry' => $row['alsgl_almdny'],
            'supervisor_name' => $row['asm_almshrf'],
            'specialization' => $row['altkhss'],
            'qualification' => $row['almohl'],
            'qualification_type' => $row['noaa_almohl'],
            'university_college_institute' => $row['algamaa_alkly_almaahd'],
            'current_job' => $row['alaaml_alhaly'],
            'mobile' => $row['algoal'],
            'email' => $row['albryd_alalktrony'],
            'employee_status' => $row['hal_almothf'],
            'performance_year_1444' => $row['aladaaa_alothyfy_llaaam_1444'],
            'performance_year_1443' => $row['aladaaa_alothyfy_llaaam1443'],
            'job_title' => $row['almsm_alothyfy'],
            'educational_directorate_day' => $row['yom_almbashr_altaalymy'],
            'educational_directorate_month' => $row['shhr_almbashr_altaalymy'],
            'educational_directorate_year' => $row['sn_almbashr_altaalymy'],
            'additional_qualifications' => $row['almohlat_aladafy'],
            'additional_qualification_specialization' => $row['tkhss_almohl_aladafy'],
            'supervisory_work_assignment_date' => $row['tarykh_aol_tklyf_balaaml_alashrafy'],
            'department_office' => $row['alksmalmktb'],
            'current_department_assignment_date' => $row['tarykh_altklyf_fy_alksm_alhaly'],
            'rank' => $row['alrtb'],
            'level' => $row['almsto'],
        ]);
    }
}
