<?php

namespace App\Http\Controllers;

use App\Models\CertificateTemplate;
use App\Models\Course;
use App\Models\User;
use Illuminate\Http\Request;

class TrainerCertificateController extends Controller
{
    public function show(Request $request, Course $course)
    {
        $template = CertificateTemplate::trainerTemplate();

        if (! $template || ! $template->template_file) {
            abort(403, __('certificate.not_available'));
        }

        $trainer = auth()->user();

        if (! $trainer->is_trainer) {
            abort(403, __('certificate.not_trainer'));
        }

        if (! $course->isEnded()) {
            abort(403, __('certificate.not_ended'));
        }

        if (! $course->trainers()->where('trainer_id', $trainer->id)->exists()) {
            abort(403, __('certificate.not_trainer_of_course'));
        }

        return view('certificate', [
            'course' => $course,
            'user' => $trainer,
            'temp' => asset('storage/'.$template->template_file),
            'download' => $request->query('download'),
        ]);
    }

    public function adminShow(Request $request, Course $course, User $user)
    {
        $template = CertificateTemplate::trainerTemplate();

        if (! $template || ! $template->template_file) {
            abort(403, __('certificate.no_template'));
        }

        $admin = auth('admin')->user();

        if (! $admin->is_super_admin) {
            abort(403, __('certificate.not_super_admin'));
        }

        if (! $user->is_trainer) {
            abort(403, __('certificate.user_not_trainer'));
        }

        //        if (! $course->isEnded()) {
        //            abort(403, 'Course is not ended');
        //        }

        if (! $course->trainers()->where('trainer_id', $user->id)->exists()) {
            abort(403, __('certificate.user_not_trainer_of_course'));
        }

        return view('certificate', [
            'course' => $course,
            'user' => $user,
            'temp' => asset('storage/'.$template->template_file),
            'download' => $request->query('download'),
        ]);
    }
}
