<?php

namespace App\Http\Controllers;

use App\Models\GeneralUser;
use App\Models\User;
use Barryvdh\DomPDF\Facade\Pdf;

class IdCardController extends Controller
{
    public function show()
    {
        $card = auth()->user()->idCard;

        if (! $card) {
            return redirect()->route('filament.generalUser.auth.login');
        }

        $works = [
            'manager' => __('input.manager'),
            'moderator' => __('input.moderator'),
        ];

        $work = $works[$card->work] ?? '';

        $employer = config('edu.employers')[$card->employer] ?? '';

        return view('card', [
            'card' => $card,
            'work' => $work,
            'employer' => $employer,
        ]);
    }

    public function showGuestId(GeneralUser $user)
    {
        $card = $user->idCard;

        if (! $card) {
            abort(404);
        }

        $works = [
            'manager' => __('input.manager'),
            'moderator' => __('input.moderator'),
        ];

        $work = $works[$card->work] ?? '';

        $employer = config('edu.employers')[$card->employer] ?? '';

        return view('guest_card', [
            'card' => $card,
            'work' => $work,
            'employer' => $employer,
            'user' => $user,
        ]);
    }

    public function pdf()
    {
        $card = auth()->user()->idCard;

        if (! $card) {
            return redirect()->route('filament.generalUser.auth.login');
        }

        $pdf = PDF::loadView('card', [
            'card' => $card,
        ])->setOptions([
            'defaultFont' => 'sans-serif',
        ]);

        return $pdf->stream('resume.pdf');
    }
}
