<?php

namespace App\Filament\SuperAdmin\Resources\TrainerResource\Pages;

use App\Filament\SuperAdmin\Resources\TrainerResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;

class CreateTrainer extends CreateRecord
{
    protected static string $resource = TrainerResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
            unset($data['password_confirmation']);
        } else {
            unset($data['password']);
            unset($data['password_confirmation']);
        }

        $data['is_trainer'] = true;

        return $data;
    }
}
