<?php

namespace App\Filament\SuperAdmin\Resources\TraineeResource\Pages;

use App\Filament\SuperAdmin\Resources\TraineeResource;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;

class CreateTrainee extends CreateRecord
{
    protected static string $resource = TraineeResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
            unset($data['password_confirmation']);
        } else {
            unset($data['password']);
            unset($data['password_confirmation']);
        }

        $data['is_trainee'] = true;

        return $data;
    }
}
