<?php

namespace App\Filament\SuperAdmin\Resources\GeneralUserResource\Pages;

use App\Filament\SuperAdmin\Resources\GeneralUserResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Hash;

class CreateGeneralUser extends CreateRecord
{
    protected static string $resource = GeneralUserResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        if ($data['password']) {
            $data['password'] = Hash::make($data['password']);
            unset($data['password_confirmation']);
        } else {
            unset($data['password']);
            unset($data['password_confirmation']);
        }

        return $data;
    }
}
