<?php

namespace App\Filament\SuperAdmin\Resources\CourseResource\Pages;

use App\Filament\SuperAdmin\Resources\CourseResource;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class EditCourse extends EditRecord
{
    protected static string $resource = CourseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
            $this->addTrainersImportAction(),
            $this->addTraineesImportAction(),
        ];
    }

    private function addTrainersImportAction()
    {
        return ImportAction::make('upload_trainers_list')
            ->label(__('action.upload_trainers_list'))
            ->fields([
                ImportField::make('national_id')
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                // التحقق من وجود الرقم الوطني وأنه غير فارغ
                if (!empty($data['national_id'])) {
                    $user = User::withTrashed()->Trainer()->where('national_id', $data['national_id'])->first();

                    if ($user) {
                        $this->record->trainers()->syncWithoutDetaching([$user->id]);
                    } else {
                        // تجاهل البيانات التي لا تتطابق مع السجلات الموجودة في قاعدة البيانات
                        return null;
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }

    private function addTraineesImportAction()
    {
        return ImportAction::make('upload_trainees_list')
            ->label(__('action.upload_trainees_list'))
            ->fields([
                ImportField::make('national_id')
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                // التحقق من وجود الرقم الوطني وأنه غير فارغ
                if (!empty($data['national_id'])) {
                    $user = User::withTrashed()->Trainee()->where('national_id', $data['national_id'])->first();

                    if ($user) {
                        $this->record->trainees()->syncWithoutDetaching([$user->id]);
                    } else {
                        // تجاهل البيانات التي لا تتطابق مع السجلات الموجودة في قاعدة البيانات
                        return null;
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }
}
