<?php

namespace App\Filament\SuperAdmin\Resources;

use App\Filament\SuperAdmin\Resources\AdminResource\Pages;
use App\Models\Admin;
use Filament\Forms;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class AdminResource extends Resource
{
    protected static ?string $model = Admin::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function getNavigationBadge(): ?string
    {
        return static::$model::count();
    }

    public static function getNavigationLabel(): string
    {
        return __('admin.admins');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('admin.group.users');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getPluralLabel(): ?string
    {
        return __('admin.admins');
    }

    /**
     * @deprecated Use `getModelLabel()` instead.
     */
    public static function getLabel(): ?string
    {
        return __('admin.admin');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('national_id')
                    ->required()
                    ->numeric()
                    ->autofocus()
                    ->unique(ignoreRecord: true)
                    ->label(__('input.national_id'))
                    ->placeholder(__('input.national_id_placeholder'))
                    ->helperText(__('input.national_id_helper_text')),

                TextInput::make('name')
                    ->required()
                    ->autofocus()
                    ->label(__('input.name'))
                    ->placeholder(__('input.name_placeholder'))
                    ->helperText(__('input.name_helper_text')),

                TextInput::make('email')
                    ->required()
                    ->email()
                    ->unique(ignoreRecord: true)
                    ->label(__('input.email'))
                    ->placeholder(__('input.email_placeholder'))
                    ->helperText(__('input.email_helper_text')),

                TextInput::make('password')
                    ->nullable()
                    ->password()
                    ->label(__('input.password'))
                    ->placeholder(__('input.password_placeholder'))
                    ->helperText(__('input.password_helper_text')),

                TextInput::make('password_confirmation')
                    ->nullable()
                    ->password()
                    ->label(__('input.password_confirmation'))
                    ->placeholder(__('input.password_confirmation_placeholder'))
                    ->helperText(__('input.password_confirmation_helper_text')),

                Forms\Components\Toggle::make('is_super_admin')
                    ->reactive()
                    ->afterStateUpdated(function ($get, $set) {
                        if ($get('is_super_admin')) {
                            $set('is_has_males', true);
                            $set('is_has_females', true);
                            $set('is_has_edu_job', true);
                            $set('is_has_manager_job', true);
                        } else {
                            $set('is_has_males', false);
                            $set('is_has_females', false);
                            $set('is_has_edu_job', false);
                            $set('is_has_manager_job', false);
                        }
                    })
                    ->label(__('input.is_super_admin')),

                Forms\Components\Toggle::make('is_has_males')
                    ->label(__('input.is_has_males')),

                Forms\Components\Toggle::make('is_has_females')
                    ->label(__('input.is_has_females')),

                Forms\Components\Toggle::make('is_has_edu_job')
                    ->label(__('input.is_has_edu_job')),

                Forms\Components\Toggle::make('is_has_manager_job')
                    ->label(__('input.is_has_manager_job')),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->sortable()
                    ->searchable()
                    ->label('ID'),

                Tables\Columns\TextColumn::make('name')
                    ->sortable()
                    ->searchable()
                    ->label(__('input.name')),

                Tables\Columns\TextColumn::make('email')
                    ->sortable()
                    ->searchable()
                    ->label(__('input.email')),

                Tables\Columns\IconColumn::make('is_super_admin')
                    ->label(__('input.is_super_admin'))
                    ->boolean(),

                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->label(__('input.created_at'))
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->label(__('input.updated_at'))
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\TrashedFilter::make(),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAdmins::route('/'),
            'create' => Pages\CreateAdmin::route('/create'),
            'view' => Pages\ViewAdmin::route('/{record}'),
            'edit' => Pages\EditAdmin::route('/{record}/edit'),
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
