<?php

namespace App\Filament\SuperAdmin\Pages;

use Filament\Forms\Components\Component;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Form;
use Filament\Pages\Auth\EditProfile as FilamentEditProfile;

class EditProfile extends FilamentEditProfile
{
    protected function getUpdateNationaIdFormComponent(): Component
    {
        return TextInput::make('national_id')
            ->required()
            ->numeric()
            ->autofocus()
            ->unique(ignoreRecord: true)
            ->label(__('input.national_id'))
            ->placeholder(__('input.national_id_placeholder'))
            ->helperText(__('input.national_id_helper_text'));
    }

    /**
     * @return array<int | string, string | Form>
     */
    protected function getForms(): array
    {
        return [
            'form' => $this->form(
                $this->makeForm()
                    ->schema([
                        $this->getUpdateNationaIdFormComponent(),
                        $this->getNameFormComponent(),
                        $this->getEmailFormComponent(),
                        $this->getPasswordFormComponent(),
                        $this->getPasswordConfirmationFormComponent(),
                    ])
                    ->operation('edit')
                    ->model($this->getUser())
                    ->statePath('data'),
            ),
        ];
    }
}
