<?php

namespace App\Filament\Employee\Widgets\Trainer;

use Filament\Tables\Actions\ViewAction;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class CoursesTableWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected int|string|array $columnSpan = 4;

    public static function canView(): bool
    {
        return auth()->user()->is_trainer && auth()->user()->trainerCourses()->StartThisWeek()->count() > 0;
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(function () {
                return auth()->user()->trainerCourses()->StartThisWeek();
            })
            ->heading(__('trainer.courses_start_this_week'))
            ->actions([
                ViewAction::make()->url(fn ($record) => route('filament.user.resources.trainer.my-courses.view', $record->course_id)),
            ])
            ->recordUrl(fn ($record) => route('filament.user.resources.trainer.my-courses.view', $record->course_id))
            ->columns([
                TextColumn::make('type.name')
                    ->sortable()
                    ->searchable()
                    ->toggleable()
                    ->label(__('input.type')),

                TextColumn::make('field.name')
                    ->sortable()
                    ->searchable()
                    ->toggleable()
                    ->label(__('input.field')),

                TextColumn::make('title')
                    ->sortable()
                    ->searchable()
                    ->label(__('input.title')),

                TextColumn::make('start_at')
                    ->date()
                    ->sortable()
                    ->toggleable()
                    ->searchable()
                    ->label(__('input.start_at')),
                TextColumn::make('end_at')
                    ->date()
                    ->sortable()
                    ->toggleable()
                    ->searchable()
                    ->label(__('input.end_at')),
            ]);
    }
}
