<?php

namespace App\Filament\Employee\Widgets;

use Filament\Widgets\Widget;
use Illuminate\Support\Facades\Hash;

class ChangeDefaultPasswordWidget extends Widget
{
    protected static string $view = 'filament.employee.widgets.change-default-password-widget';

    public string $type = 'danger';

    public static function canView(): bool
    {
        return Hash::check(auth()->user()->national_id, auth()->user()->password);
    }

    public function getLabel(): string
    {
        return __('action.change_default_password');
    }
}
