<?php

namespace App\Filament\Employee\Resources\Trainer\MyCourseResource\Pages;

use App\Filament\Employee\Resources\Trainer\MyCourseResource;
use App\Models\CourseType;
use Filament\Resources\Pages\ListRecords;

class ListMyCourses extends ListRecords
{
    protected static string $resource = MyCourseResource::class;

    public function getTabs(): array
    {
        $courseTypesThatHasMaxNumberOfCourses = CourseType::withCount('courses')->orderBy('courses_count', 'desc')->take(5)->get();

        $tabs = [
            null => ListRecords\Tab::make(__('filters.menu.all')),
        ];

        foreach ($courseTypesThatHasMaxNumberOfCourses as $courseType) {
            $tabs[$courseType->id] = ListRecords\Tab::make($courseType->name)->query(fn ($query) => $query->where('course_type_id', $courseType->id));
        }

        return $tabs;
    }

    protected function getHeaderActions(): array
    {
        return [
        ];
    }
}
