<?php

namespace App\Filament\Admin\Resources\TraineeResource\Pages;

use App\Enums\Gender;
use App\Filament\Admin\Resources\TraineeResource;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\Hash;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class ListTrainees extends ListRecords
{
    protected static string $resource = TraineeResource::class;

    public function getTabs(): array
    {
        return [
            null => ListRecords\Tab::make(__('filters.menu.all')),
            'males' => ListRecords\Tab::make(__('filters.menu.males'))->query(fn ($query) => $query->AdminControl()->Trainee()->Male()),
            'females' => ListRecords\Tab::make(__('filters.menu.females'))->query(fn ($query) => $query->AdminControl()->Trainee()->Female()),
            'has_edu_job' => ListRecords\Tab::make(__('filters.menu.has_edu_job'))->query(fn ($query) => $query->AdminControl()->Trainee()->EduJob()),
            'has_manager_job' => ListRecords\Tab::make(__('filters.menu.has_manager_job'))->query(fn ($query) => $query->AdminControl()->Trainee()->ManagerJob()),
        ];
    }

    protected function getHeaderActions(): array
    {
        return [
            //            Actions\CreateAction::make(),
            //            $this->addImportAction(),
            //            $this->addDeletedUsersImportAction(),
        ];
    }

    private function addDeletedUsersImportAction()
    {
        return ImportAction::make('upload_deleted_users_list')
            ->label(__('action.upload_deleted_users_list'))
            ->uniqueField('national_id')
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->label(__('input.national_id')),

            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = User::Trainee()->where('national_id', $data['national_id'])->first();
                if ($user) {
                    $user->delete();
                }

                return $data;
            })->disableRecordCreation();
    }

    private function addImportAction()
    {
        return ImportAction::make('upload_users_list')
            ->label(__('action.upload_users_list'))
            ->uniqueField('national_id')
            ->fields([
                ImportField::make('name')
                    ->required()
                    ->label(__('input.name')),

                ImportField::make('email')
                    ->required()
                    ->label(__('input.email')),

                ImportField::make('gender')
                    ->required()
                    ->rules('in:'.implode(',', Gender::values()))
                    ->label(__('input.gender')),

                ImportField::make('national_id')
                    ->required()
                    ->rules('unique:users,national_id')
                    ->label(__('input.national_id')),

                ImportField::make('max_courses_per_year')
                    ->required()
                    ->rules('integer')
                    ->label(__('input.max_courses_per_year')),

                //                ImportField::make('is_trainee')
                //                    ->required()
                //                    ->rules('boolean')
                //                    ->label(__('input.is_trainee')),

                ImportField::make('is_trainer')
                    ->required()
                    ->rules('boolean')
                    ->label(__('input.is_trainer')),

                ImportField::make('office_id')
                    ->required()
                    ->label(__('input.office_id')),

                ImportField::make('school_id')
                    ->required()
                    ->label(__('input.school_id')),

                ImportField::make('phone')
                    ->label(__('input.phone')),

                ImportField::make('has_edu_job')
                    ->label(__('input.has_edu_job')),
                ImportField::make('has_manager_job')
                    ->label(__('input.has_manager_job')),

            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($row) {
                $row = array_map('trim', $row);
                $national_id = $row['national_id'];
                $row['password'] = Hash::make($national_id);
                $row['is_trainee'] = true;

                return $row;
            });
    }
}
