<?php

namespace App\Filament\Admin\Resources\CourseResource\Pages;

use App\Filament\Admin\Resources\CourseResource;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Konnco\FilamentImport\Actions\ImportAction;
use Konnco\FilamentImport\ImportField;

class EditCourse extends EditRecord
{
    protected static string $resource = CourseResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\ViewAction::make(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
            $this->addTrainersImportAction(),
            $this->addTraineesImportAction(),
            $this->addTraineesAttendanceImportAction(),
        ];
    }

    private function addTrainersImportAction()
    {
        return ImportAction::make('upload_trainers_list')
            ->label(__('action.upload_trainers_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->rules('exists:users,national_id')
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = User::withTrashed()->Trainer()->where('national_id', $data['national_id'])->first();

                if (!$user) {
                    throw new \Exception('Trainer with national ID '.$data['national_id'].' not found.');
                }

                $this->record->trainers()->syncWithoutDetaching([$user->id]);

                return $data;
            })
            ->disableRecordCreation();
    }

    private function addTraineesImportAction()
    {
        return ImportAction::make('upload_trainees_list')
            ->label(__('action.upload_trainees_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->rules('exists:users,national_id')
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = User::withTrashed()->Trainee()->where('national_id', $data['national_id'])->first();

                if (!$user) {
                    throw new \Exception('Trainee with national ID '.$data['national_id'].' not found.');
                }

                $this->record->trainees()->syncWithoutDetaching([$user->id]);

                return $data;
            })
            ->disableRecordCreation();
    }

    private function addTraineesAttendanceImportAction()
    {
        return ImportAction::make('upload_trainees_attendance_list')
            ->label(__('action.upload_trainees_attendance_list'))
            ->fields([
                ImportField::make('national_id')
                    ->required()
                    ->rules('exists:users,national_id')
                    ->label(__('input.national_id')),
            ])
            ->handleBlankRows(true)
            ->mutateBeforeCreate(function ($data) {
                $user = User::withTrashed()->Trainee()->where('national_id', $data['national_id'])->first();

                if (!$user) {
                    throw new \Exception('Trainee with national ID '.$data['national_id'].' not found.');
                }

                $days = $this->record->getDays();
                foreach ($days as $day) {
                    $existingAttendance = $this->record->attendances()->where('trainee_id', $user->id)->where('attended_at', $day)->exists();
                    if (!$existingAttendance) {
                        $this->record->attendances()->create([
                            'trainee_id' => $user->id,
                            'attended_at' => $day,
                        ]);
                    }
                }

                return $data;
            })
            ->disableRecordCreation();
    }
}
