<?php

namespace App\Filament\Admin\Pages;

use Filament\Forms\Components\Component;
use Filament\Forms\Components\TextInput;
use Filament\Pages\Auth\Login as FilamentLogin;

class Login extends FilamentLogin
{
    protected function getEmailFormComponent(): Component
    {
        return TextInput::make('login_key')
            ->label(__('action.login_with_email_or_national_id'))
            ->required()
            ->autocomplete()
            ->autofocus()
            ->extraInputAttributes(['tabindex' => 1]);
    }

    protected function getCredentialsFromFormData(array $data): array
    {
        $login_key = $data['login_key'];

        if (filter_var($login_key, FILTER_VALIDATE_EMAIL)) {
            $key = 'email';
            $value = $login_key;
        } else {
            $key = 'national_id';
            $value = $login_key;
        }

        return [
            $key => $value,
            'password' => $data['password'],
        ];
    }
}
