<?php

namespace App\Exports;

use pxlrbt\FilamentExcel\Exports\ExcelExport;

class CourseTypeExport extends ExcelExport
{
    public function setUp(): void
    {
        $this->askForFilename(
            default: 'Courses-Types-'.date('Y-m-d').' - export',
            label : __('action.export_file_name')
        )->askForWriterType(
            default: \Maatwebsite\Excel\Excel::XLSX,
            options: config('exports.types'),
            label: __('action.export_file_type'),
        )->fromModel()->only([
            'id',
            'name',
        ])->withWriterType(\Maatwebsite\Excel\Excel::XLSX);
    }
}
