<?php

namespace App\Enums;

enum Gender: string
{
    case MALE = 'male';
    case FEMALE = 'female';

    public static function values(): array
    {
        return [
            self::MALE->value,
            self::FEMALE->value,
        ];
    }

    public static function valuesForSelect(): array
    {
        return [
            self::MALE->value => __('gender.male'),
            self::FEMALE->value => __('gender.female'),
        ];
    }
}
